#### Overview

- **Purpose**: Simplifies provisioning and management of secure access to network services and applications.
- **Key Advantage**: Defines policies using logical groupings instead of relying on network topology (e.g., IP addresses or VLANs).
    - Consistent security across wired, wireless, and VPN networks.
    - Reduces operational costs and simplifies policy maintenance.
    - Enables seamless policy implementation even in dynamic, virtualized networks.

---

### Key Components of Cisco TrustSec

#### **1. Classification**

- **Definition**: Assigns Security Group Tags (SGTs) to endpoints.
- **Types**:
    - **Dynamic Classification**:
        - Performed at the access layer.
        - Uses Cisco Identity Services Engine (ISE) for decisions.
        - Methods: 802.1X, MAC Authentication Bypass (MAB), or web authentication.
    - **Static Classification**:
        - Configured at the egress switch, typically in the data center.
        - Methods: Mapping IP addresses, VLANs, or ports to SGTs.

---

#### **2. Transport**

- **Purpose**: Propagates SGT mappings across the network.
- **Methods**:
    - **Inline Tagging**:
        - Embeds the SGT in the Ethernet frame header.
        - Supported by devices configured for Cisco TrustSec.
    - **SGT Exchange Protocol (SXP)**:
        - Used when devices do not support inline tagging.
        - Transports SGT mappings based on source IP address.

---

#### **3. Enforcement**

- **Definition**: Implements access policies (permit/deny) based on SGTs.
- **Key Enforcement Mechanisms**:
    - **Security Group Access Control Lists (SGACLs)**:
        - Configured on switches to enforce permissions between source and destination SGTs.
    - **Security Group Firewalls (SGFW)**:
        - Used on routing and firewall platforms for access control.

---

### Cisco TrustSec Access Control

#### **Ingress Tagging**

- At the network entry point, traffic is tagged with an SGT corresponding to the source's security group.

#### **Egress Enforcement**

- At the exit point, the destination SGT is determined to apply the appropriate SGACL from a centralized policy matrix.

#### **Policy Matrix Example**:

- **Tags**:
    - Employees: SGT = 5.
    - Managers: SGT = 4.
    - Application Servers: SGT = 10.
    - Financial Servers: SGT = 14.
- **Policy**:
    - Employees can access application servers but not financial servers.
    - Managers can access all servers.

---

### Benefits of Cisco TrustSec

#### **Simplified Policy Management**

- Policies are defined based on business roles, independent of IP addresses or VLANs.
- Centralized policy updates propagate automatically across the network.

#### **Reduction in Complexity**

- SGACLs reduce the size and number of access control entries (ACEs) compared to traditional ACLs.
- Changes in network topology do not require changes to SGACL-based policies.

#### **Efficient Use of Resources**

- SGACLs result in better utilization of memory (e.g., TCAM) compared to traditional ACLs.

---

### Cisco TrustSec Propagation

#### **SGT Assignment**

- **Source SGT**:
    - Assigned dynamically by Cisco ISE or statically at a switch.
- **Destination SGT**:
    - Assigned at the egress switch or fetched from Cisco ISE via SGT Exchange Protocol (SXP)

#### **Methods for Propagation**:

- **Inline Tagging**:
    - SGT is embedded in the Ethernet header for capable devices.
- **SXP Protocol**:
    - Maps IP addresses to SGTs and propagates them to enforcement points.

---

### Inline SGT Tagging

- **Mechanism**:
    - SGTs are carried in the Cisco TrustSec Metadata header (16-bit field).
    - Adds ~20 bytes of overhead in Ethernet frames.
- **MACsec Integration**:
    - Frames can be protected by MACsec (802.1AE) encryption and authentication.

---

### Cisco TrustSec Enforcement

#### **SGACLs (Security Group ACLs)**

- **Policy Matrix**:
    - Defines access permissions between source and destination SGTs.
    - Role-based and topology-independent.
- **Advantages**:
    - Simplifies ACL management.
    - Policies are centrally defined in Cisco ISE and dynamically pushed to enforcement points.

#### **SGFW (Security Group Firewall)**

- **Alternative Enforcement**:
    - SGT-aware firewalls (e.g., Cisco Secure Firewall) use SGTs for policy application.
    - Firewall policies are IP address agnostic.

---

### Comparison to Traditional Access Control

- **Traditional ACLs**:
    - Depend on static IP addresses or VLANs.
    - Require frequent updates and maintenance.
    - Complex and repetitive entries.
- **Cisco TrustSec**:
    - Role-based, dynamic, and simplified.
    - Reduces operational overhead and the potential for errors.

---

### Summary of Key Advantages

- **Role-Based Access Control**:
    - Policies are based on business needs, not networking details.
- **Simplified Maintenance**:
    - Centralized management in Cisco ISE ensures consistency.
- **Scalability**:
    - Supports dynamic environments and virtualized networks.
- **Security**:
    - Enhanced protection through tagging and encryption mechanisms like MACsec.